/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.common.action;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.flow.DefaultAction;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.Route;
import oracle.install.driver.oui.OUIMetadata;

public class AutoUpdatesDeciderAction
extends DefaultAction {
    private static final String STARTUP_LOCATION = System.getProperty("oracle.installer.startup_location");
    private static final Logger logger = Logger.getLogger(AutoUpdatesDeciderAction.class.getName());
    private String scratchPathLoc = System.getProperty("oracle.installer.scratchPath");

    public Route transition(FlowContext flowContext) {
        String autoUpdatesEnable = null;
        File metadataFile = new File(STARTUP_LOCATION, File.separator + ".." + File.separator + "stage" + File.separator + "shiphomeproperties.xml");
        OUIMetadata metadata = null;
        try {
            metadata = OUIMetadata.newInstance((File)metadataFile);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Error in retrieving metadata from shiphomeproperties xml", e.getCause());
        }
        if (metadata != null && (autoUpdatesEnable = metadata.getProperty("ENABLE_SOFTWARE_UPDATES")) != null && autoUpdatesEnable.equalsIgnoreCase("false")) {
            if (flowContext.getFlowControl() != null) {
                flowContext.getFlowControl().lookAhead(new Route("AUTO_UPDATES_DISABLE"));
            }
            return new Route("AUTO_UPDATES_DISABLE");
        }
        String val = System.getProperty("oracle.install.restartSession");
        if (val != null && val.equalsIgnoreCase("true")) {
            if (flowContext.getFlowControl() != null) {
                flowContext.getFlowControl().lookAhead(new Route("AUTO_UPDATES_STATE_SKIP"));
            }
            return new Route("AUTO_UPDATES_STATE_SKIP");
        }
        return Route.SUCCESS;
    }
}

